using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Godot;

namespace Rokojori
{

  public class SerializedScene
  {
    public List<SerializedResource> resources = new List<SerializedResource>();
    public List<SerializedNode> nodes = new List<SerializedNode>();   

    public void Serialize( Node rootNode, params Node[] skip )
    {      
      int serializationID = 0;
      
      var _nodeToIDMap = new Dictionary<Node, int>();

      Nodes.Iterate( [ rootNode ], 
        ( n )=>
        {
          if ( n == null || skip.Contains( n ) )
          {
            return;
          }

          var id = serializationID; 
          serializationID ++;

          var serializedNode = new SerializedNode();

          _nodeToIDMap[ n ] = id;

          nodes.Add( serializedNode );

          var parentID = _nodeToIDMap.ContainsKey( n.GetParent() ) ? _nodeToIDMap[ n.GetParent() ] : -1;

          serializedNode.Serialize( id, parentID, n );

        }
      );

      RJLog.Log( "Num Nodes:", nodes.Count );
    }

  }

}