
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class EvaluateSelector:Action
  {   
    [Export]
    public Node node;

    [Export]
    public Selector selector;

    [Export]
    public Action onSelected;

    [Export]
    public Action onNotSelected;

    protected override void _OnTrigger()
    {
      this.LogInfo( "Evaluate" );

      if ( node == null )
      {
        this.LogInfo( "node == null" );
        return;
      }

      var selected = Selector.IsSelecting( selector, node );

      this.LogInfo( selected );

      if ( selected )
      {
        Trigger( onSelected );
      }
      else
      {
        Trigger( onNotSelected );
      }
    }
  }
}