
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Linq;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Selector.svg")]
  public partial class FlagSelector:Selector
  {   
    [Export]
    public SelectorFlag[] flag;

    public enum FlagMode
    {
      Needs_One_Flag,
      Needs_All_Flags
    }

    [Export]
    public FlagMode mode = FlagMode.Needs_One_Flag;

    [Export]
    public TreeIteratorType iteratorType = TreeIteratorType.DirectChildren;

    bool SelectsSelectable( Selectable s )
    {
      var numPresent = 0;

      for ( int i = 0; i < flag.Length; i++ )
      {
        if ( Array.IndexOf( s.flags, flag[ i ] ) != -1 )
        {
          numPresent ++;
        }
      }

      if ( numPresent == flag.Length || mode == FlagMode.Needs_One_Flag && numPresent > 0 )
      {
        return true;
      }

      return false;
    } 

    public override bool Selects( Node node )
    {
      var iterator = TreeIterator<Node>.GetIterator( iteratorType, node, NodesWalker.Get() );

      while ( iterator.HasNext() )
      {
        iterator.MoveToNext();

        var it = iterator.Current();

        if ( it is Selectable s )
        {
          var selects = SelectsSelectable( s );

          if ( selects )
          {
            return true;
          }

        }
      }

      return false;

    }

  }
}