
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Selector.svg")]
  public abstract partial class Selector:Resource
  {   
    public virtual bool Selects( Node node )
    {
      return true;
    }

    public static bool IsSelecting( Selector selector, Node node )
    {
      return selector == null || selector.Selects( node );
    }
  }
}