
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  public class Selectors
  {
    public static T GetFromDirectChildren<T>( Node parent, Selector s ) where T:Node 
    {
      T selected = null;

      Nodes.ForEachDirectChild<T>( parent,
        ( T t )=>
        {
          if ( selected != null )
          {
            return;
          }

          if ( s != null && s.Selects( t ) )
          {
            selected = t;
          }
        }
      );

      return selected;
    }

  }

}