
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class CombineSensor : Sensor
  {
    [Export] 
    public Sensor[] sensors = new Sensor[ 0 ];   

    [ExportGroup("UI")]
    [Export]
    public bool showOnlyVisibleIcons = false;

    [Export]
    public int numVisible = 0;

    protected override void UpdateValue()
    {
      var value = 0f;

      for ( int i = 0; i < sensors.Length; i++ )
      {
        value = Mathf.Max( value, sensors[ i ].value );
      }

      SetFloatValue( value );
    }

     public override string ToString()
    {
      return RJLog.GetInfo( this, sensors );
    }

    [Export]
    public InputIcon[] inputIcons = new InputIcon[ 0 ];

    [Export]
    public bool useInputIconsFromSensors = true;

    public override List<InputIcon> GetInputIcons()
    {
      var list = Lists.From( inputIcons );

      if ( useInputIconsFromSensors )
      {
        var visible = showOnlyVisibleIcons ? numVisible : sensors.Length;
        
        for ( int i = 0; i < visible; i++ )
        {
          list.AddRange( sensors[ i ].GetInputIcons() );
        }
      }

      return list;
    }
  }
}