
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class DefaultSensorDeviceSelector: SensorDeviceSelector
  {
    public enum DefaultDeviceType
    {
      GamePad,
      Keyboard_and_Mouse,
      Keyboard,
      Mouse
    } 

    [Export]
    public DefaultDeviceType deviceType;

    public static bool IsMouseDevice( SensorDevice device )
    {
      if ( device is MouseDevice )
      {
        return true;
      }

      if ( device is MultiSensorDevice m )
      {
        return m.devices.HasNonNull( d => IsMouseDevice( d ) ) ;
      }

      return false;
    }

    public override bool Selects( SensorDevice sensorDevice )
    {
      if ( sensorDevice is MultiSensorDevice m )
      {
        return m.devices.HasNonNull( d => Selects( d ) );
      }

      if ( DefaultDeviceType.GamePad == deviceType )
      {
        return sensorDevice is GamePadDevice;
      }

      if ( DefaultDeviceType.Keyboard == deviceType )
      {
        return sensorDevice is KeyboardDevice;
      }

      if ( DefaultDeviceType.Mouse == deviceType )
      {
        return sensorDevice is MouseDevice;
      }

      if ( DefaultDeviceType.Keyboard_and_Mouse == deviceType )
      {
        return sensorDevice is MouseDevice || sensorDevice is KeyboardDevice;
      }      

      return false;
    }
  }
}