
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class LastActiveDeviceFilter : DeviceFilter
  {
    public override bool BelongsToDevice( InputIcon icon )
    {
      var sm = Unique<SensorManager>.Get();

      if ( sm == null )
      {
        this.LogInfo( "No SensorManager" );
        return false;
      }

      var device = sm.lastActiveDevice;

      if ( device == null )
      {
        return false;
      }
      
      return device.ContainsIcon( icon );
    }
  }
}