
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public enum GamePadDeviceType
  {
    XBox,
    PS,
    Switch
  }

  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class GamePadDevice: SensorDevice
  {
    [Export]
    public int deviceIndex = 0;

    [Export]
    public string deviceName;

    [Export]
    public GamePadDeviceType deviceType = GamePadDeviceType.XBox;
    

    public override LocalizedString GetDeviceName()
    {
      return LocaleText.Create( deviceName );
    }

    public override bool ContainsSensor( Sensor sensor )
    {
      return ReflectionHelper.IsTypeOneOf( sensor, 
        typeof( GamePadAxisSensor ),
        typeof( GamePadButtonSensor )
      );
    }

    public override bool ContainsIcon( InputIcon icon )
    {
      if ( icon is CombinedIcon ci )
      {
        return ci.icons.Length == 1 && ContainsIcon( ci.icons[ 0 ] );
      }

      return ReflectionHelper.IsTypeOneOf( icon, 
        typeof( GamePadAxisIcon ),
        typeof( GamePadButtonIcon )
      );
    }
  }
}