
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class MouseDevice: SensorDevice
  {
    public override LocalizedString GetDeviceName()
    {
      return LocaleText.Create( "Mouse" );
    }

    public override bool ContainsSensor( Sensor sensor )
    {
      return ReflectionHelper.IsTypeOneOf( sensor, 
        typeof( MouseButtonSensor ), 
        typeof( MouseMotionDelta ), 
        typeof( MouseScreenRelative )
      );
    }

    public override bool ContainsIcon( InputIcon icon )
    {
      if ( icon is CombinedIcon ci )
      {
        return ci.icons.Length == 1 && ContainsIcon( ci.icons[ 0 ] );
      }
      
      return ReflectionHelper.IsTypeOneOf( icon, 
        typeof( MouseInputIcon )
      );
    }
  }
}