
using Godot;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class MultiSensorDevice: SensorDevice
  {
    [Export]
    public SensorDevice[] devices = new SensorDevice[ 0 ];

    public override string GetInfo()
    {
      return GetType().Name + devices.Map( d => d.GetInfo() ).Join( ", " );
    }

    [Export]
    public Sensor[] sensors = new Sensor[ 0 ];

    public override bool ContainsSensor( Sensor sensor )
    {
      for ( int i = 0; i < devices.Length; i++ )
      {
        if ( devices[ i ].ContainsSensor( sensor ) )
        {
          return true;
        }
      }

      return Arrays.Contains( sensors, sensor );
    }

    public override bool ContainsIcon( InputIcon icon )
    {
      for ( int i = 0; i < devices.Length; i++ )
      {
        if ( devices[ i ].ContainsIcon( icon ) )
        {
          return true;
        }
      }

      return false;
    }
  }
}