
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class SensorDevice: Resource
  {

    public virtual string GetInfo()
    {
      return GetType().Name;
    }

    public virtual LocalizedString GetDeviceName()
    {
      return LocaleText.Create( "---" );
    }

    public virtual bool ContainsSensor( Sensor sensor )
    {
      return false;
    }

    public virtual bool ContainsIcon( InputIcon icon )
    {
      return false;
    }
  }
}