
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/AxisSensor.svg")]
  public partial class GamePadAxisSensor : Sensor, iOnInputSensor
  {
    [Export]
    public JoyAxis axis;

    public override bool isMultiDevice => true;

    [Export]
    public GamePadAxisType type;

    public override string ToString()
    {
      return RJLog.GetInfo( this, axis, type );
    }
    
    float _lastInput = 0;

    protected override void UpdateValue()
    {
      SetFloatValue( _lastInput );
    }

    public void _Input( InputEvent ev )
    {
      var joypadAxisEvent = ev as InputEventJoypadMotion;

      if ( joypadAxisEvent == null )
      {
        return;
      } 

      if ( joypadAxisEvent.Axis != axis )
      {
        return;
      }

      _lastInput = Mathf.Max( (GamePadAxisType.Negative == type ? -1 : 1 ) * joypadAxisEvent.AxisValue, 0 );

      UpdateSensorUsage( joypadAxisEvent.Device );
  
    }

    public override List<InputIcon> GetInputIcons()
    {
      var icon = new GamePadAxisIcon();
      icon.axis = axis;
      icon.type = type;

      return new List<InputIcon>(){ icon };
    }
    

        
  }
}