
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class GamePadButtonSensor : Sensor, iOnInputSensor
  {
    [Export]
    public JoyButton button;
    
    public override bool isMultiDevice => true;
    
    float _lastInput = 0;

    protected override void UpdateValue()
    {
      SetFloatValue( _lastInput );
    }

    public override string ToString()
    {
      return RJLog.GetInfo( this, button );
    }
    
    public void _Input( InputEvent ev )
    {
      var joypadButtonEvent = ev as InputEventJoypadButton;

      if ( joypadButtonEvent == null )
      {
        return;
      } 

      if ( joypadButtonEvent.ButtonIndex != button )
      {
        return;
      }

      _lastInput = joypadButtonEvent.IsPressed() ? 1 : 0; 

      UpdateSensorUsage( joypadButtonEvent.Device );
  
    }

    public override List<InputIcon> GetInputIcons()
    {
      var icon = new GamePadButtonIcon();
      icon.button = button;

      return new List<InputIcon>(){ icon };
    }
        
  }
}