
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class HoldSensor : Sensor
  {
    [Export] 
    public Sensor holdButton;

    [Export]
    public bool negateHoldButton;

    [Export]
    public Sensor triggerButton;

    protected override void UpdateValue()
    {      
      if ( holdButton == null || triggerButton == null )
      {
        SetFloatValue( 0 );
        return;
      }

      var holdButtonValue = holdButton.isActive;

      if ( negateHoldButton )
      {
        holdButtonValue = ! holdButtonValue;
      }

      if ( ! holdButtonValue )
      {
        SetFloatValue( 0 );
        return;
      }

      SetFloatValue( triggerButton.value );
    }

     public override string ToString()
    {
      return RJLog.GetInfo( this, holdButton, triggerButton );
    }

    [Export]
    public InputIcon[] inputIcons = [];

    [Export]
    public bool useInputIconsFromSensors = true;

    public override List<InputIcon> GetInputIcons()
    {
      var list = Lists.From( inputIcons );

      if ( useInputIconsFromSensors )
      {     
        if ( holdButton != null )
        {
          list.AddRange( holdButton.GetInputIcons() );   
        }

        if ( triggerButton != null )
        {
          list.AddRange( triggerButton.GetInputIcons() );   
        }
      }

      return list;
    }
  }
}