
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class CombinedIconsDefinition: InputIconDefinition
  {      
    [Export]
    public CombinedInputIconsTexture[] combined = new CombinedInputIconsTexture[ 0 ];

    

    public override int ResolveIcons( int offset, List<InputIcon> icons )
    {
      // this.LogInfo( "ResolveIcons", offset, icons );

      var resolved = GetIconFor( offset, icons );

      if ( resolved == null )
      {
        return -1;
      }

      return resolved.icons.Length;
    }

    public CombinedInputIconsTexture GetIconFor( int offset, List<InputIcon> icons )
    {
      for ( int i = 0; i < combined.Length; i++ )
      {
        var isIcon = combined[ i ].IsIcon( offset, icons );

        // RJLog.Log( "isIcon -> offset:", offset, "isIcon:", isIcon, "icons:", icons );

        if ( isIcon )
        {
          return combined[ i ];
        } 
      }

      return null;
    }

    public override List<IconElement> GetIconElementsForIcon( InputIcon icon )
    { 
      var ci = icon as CombinedIcon;

      if ( ci == null )
      {
        return null;
      }

      var resolved = GetIconFor( 0, Lists.From( ci.icons ) );

      if ( resolved == null )
      {
        // RJLog.Log( "CombinedIcon: null");
        return null;
      }

      

      var resolvedList = new List<IconElement>();
      resolvedList.Add(  TextureIconElement.Create( resolved.texture, resolved.widthScale ) );
    
      if ( resolved.label != null )
      {
        var labelText = LabelIconElement.Create( resolved.label, resolved.fontSizeScale, resolved.isUpperCase );
        resolvedList.Add( labelText );
      }


      return resolvedList;      

    }

    public override bool HasIconFor( InputIcon icon )
    {
      if ( ! ( icon is CombinedIcon ci ) )
      {
        return false;
      }

      var ic = GetIconFor( 0, Lists.From( ci.icons ) );

      return ic != null;
    }
    

  }
}