
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class CombinedInputIconsTexture: Resource
  { 
    [Export] 
    public InputIcon[] icons = new InputIcon[ 0 ];

    [Export]
    public Texture2D texture;

    [Export]
    public float widthScale = 1;
    
    [Export]
    public CombineIconOrderMode orderMode = CombineIconOrderMode.Any_Order;
    
    [Export]
    public LocalizedString label;

    [Export]
    public bool isUpperCase = true;

    [Export]
    public float fontSizeScale = 1;

    public bool IsIcon( int offset, List<InputIcon> iconList )
    {
      var iconOrder = new List<InputIcon>();

      for ( int i = 0; i < icons.Length && ( i + offset ) < iconList.Count ; i++ )
      {
        var icon = iconList[ offset + i ];

        if ( icon == null )
        {
          return false;
        }

        if ( ! Arrays.ContainsEqual( icons, icon ) )
        {
          return false;
        }
        
        if ( Lists.ContainsEqual( iconOrder, icon ) )
        {
          return false;
        }

        iconOrder.Add( icon );
      }

      if ( iconOrder.Count != icons.Length )
      {
        return false;
      }

      if ( CombineIconOrderMode.Forward_Only == orderMode )
      {
        return Lists.AreEntriesEqual( iconOrder, Lists.From( icons ) );
      }
      else if ( CombineIconOrderMode.Forward_And_Reverse == orderMode )
      {
        var list  = Lists.From( icons );
        var listR = Lists.From( icons ); listR.Reverse();
        
        return Lists.AreEntriesEqual( iconOrder, list ) || Lists.AreEntriesEqual( iconOrder, listR );
      }

      return true;  
      
    }

  }
}