
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class DefaultInputIconDefinition: InputIconDefinition
  {  
    [Export]
    public Texture2D backgroundTexture;

    [Export]
    public float widthScale = 1;

    [ExportGroup("Font")]

    [Export]
    public float fontSizeScale = 1;

    [Export]
    public float fontSizeCharacterMultiply = 0.9f;

    [Export]
    public bool fontIsUpperCase = true;

    [Export]
    public bool hasLabel = true;

    [ExportGroup("Borders")]
    [Export]
    public float borderLeft = 0;

    [Export]
    public float borderRight = 0;

    [Export]
    public float borderTop = 0;

    [Export]
    public float borderBottom = 0;

        
    
    public bool hasBorders
    {
      get 
      {
        return ( borderLeft + borderRight + borderTop + borderBottom ) > 0;
      }
    }


    [ExportGroup("Overlays")]

    [Export]
    public Texture2D leftIndicatorTexture;

    [Export]
    public Texture2D rightIndicatorTexture;

    
    public override List<IconElement> GetIconElementsForIcon( InputIcon icon )
    {
      var list = new List<IconElement>();

      var bg = TextureIconElement.Create( backgroundTexture, widthScale );
      bg.SetBorders( this );
      list.Add( bg );


      if ( icon is KeyIcon ki )
      {
        if ( hasLabel )
        {
          var locale = ki.GetIconLocale();
          var fontScale = fontSizeScale * Mathf.Pow( fontSizeCharacterMultiply, locale.currentValue.Length - 1 );

          var label = LabelIconElement.Create( locale, fontScale, fontIsUpperCase );
          list.Add( label );
        }

        if ( KeyLocation.Unspecified != ki.location )
        {
          var indicatorTexture =  KeyLocation.Left == ki.location ? leftIndicatorTexture : 
                                  KeyLocation.Right == ki.location ? rightIndicatorTexture : null;

          
          if ( indicatorTexture != null )
          {             
            var indicatorElement = TextureIconElement.Create( indicatorTexture, widthScale );
            indicatorElement.alignment = KeyLocation.Left == ki.location ? TextureIconOverlayAlignment.Left : 
                                         KeyLocation.Right == ki.location ? TextureIconOverlayAlignment.Right : 
                                         TextureIconOverlayAlignment.Center;
            list.Add( indicatorElement );
          }
        }
      } 

      if ( icon is GamePadButtonIcon bi )
      { 
        if ( hasLabel )
        {
          var locale = bi.GetIconLocale();
          var fontScale = fontSizeScale * Mathf.Pow( fontSizeCharacterMultiply, locale.currentValue.Length - 1 );

          var label = LabelIconElement.Create( locale, fontScale, fontIsUpperCase );
          list.Add( label );
        }
      }
      
       if ( icon is GamePadAxisIcon ai )
      { 
        if ( hasLabel )
        {
          var locale = ai.GetIconLocale();
          var fontScale = fontSizeScale * Mathf.Pow( fontSizeCharacterMultiply, locale.currentValue.Length - 1 );

          var label = LabelIconElement.Create( locale, fontScale, fontIsUpperCase );
          list.Add( label );
        }
      }

      return list;
    }

  }
}