
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class DirectionalInputIconDefinition: InputIconDefinition
  {  
    [Export]
    public Texture2D backgroundTexture;

   
    [ExportGroup("Directions")]



    [Export]
    public Texture2D directionRightTexture;

    [Export]
    public Texture2D directionDownTexture;

    [Export]
    public Texture2D directionLeftTexture;

    [Export]
    public Texture2D directionUpTexture;

    [Export]
    public float directionalOffset = 0;


    [ExportGroup("Overlays")]
    [Export]
    public LocaleText label;

    [Export]
    public float fontSizeScale = 1;

    [Export]
    public bool isUpperCase = true;

    [Export]
    public Texture2D buttonPressTexture;


    static int GetAngle<T>( T value, params T[] values )
    { 
      var index = Arrays.IndexOf( values, value );

      if ( index == -1 )
      {
        return index;
      }

      return index * 90;
    }

    public static int GetAngleOfIcon( InputIcon icon )
    {
      if ( icon is GamePadButtonIcon bi )
      {
        return GetAngle( bi.button, JoyButton.DpadRight, JoyButton.DpadDown, JoyButton.DpadLeft, JoyButton.DpadUp );
      }
      else if ( icon is GamePadAxisIcon ai )
      {
        if ( JoyAxis.LeftX == ai.axis || JoyAxis.RightX == ai.axis )
        {
          return GamePadAxisType.Positive == ai.type ? 0 : 180;
        }

        if ( JoyAxis.LeftY == ai.axis || JoyAxis.RightY == ai.axis )
        {
          return GamePadAxisType.Positive == ai.type ? 90 : 270;
        }

      }
      

      return -1;
    }

    public override List<IconElement> GetIconElementsForIcon( InputIcon icon )
    {
      var list = new List<IconElement>();

      var bg = TextureIconElement.Create( backgroundTexture, 1 );
      list.Add( bg );

      if ( label != null )
      {
        var labelText = LabelIconElement.Create( label, fontSizeScale, isUpperCase );
        list.Add( labelText );
      }

      if ( icon is GamePadAxisIcon || icon is GamePadButtonIcon )
      { 
        var ai = icon as GamePadAxisIcon;
        var bi = icon as GamePadButtonIcon;
        var angle = ai != null ? GetAngleOfIcon( ai ) : GetAngleOfIcon( bi );
        var rotation = 0f;
        var texture = GetDirectionTexture( angle, out rotation );

        var dir = TextureIconElement.Create( texture, 1 ); 
        dir.alignment = TextureIconOverlayAlignment.Left;

        dir.rotation = rotation;

        list.Add( dir );
      }
      

      return list;
    }

    List<Texture2D> GetAllTextures()
    {
      return new List<Texture2D>(){ directionRightTexture, directionDownTexture, directionLeftTexture, directionUpTexture };
    }

    Texture2D GetDirectionTexture( int angle, out float rotation )
    {
      var textures = GetAllTextures();

      var nonNullIndex = -1;
      rotation = 0;

      for ( int i = 0; i < textures.Count; i++ )
      {
        if ( textures[ i ] == null )
        {
          continue;
        }

        if ( i * 90 == angle )
        {          
          return textures[ i ];
        }

        if ( nonNullIndex != -1 )
        {
          continue;
        }

        nonNullIndex = i;
        
      }

      if ( nonNullIndex == -1 )
      {
        return null;
      }

      rotation = angle - nonNullIndex * 90;
      return textures[ nonNullIndex ];


    }

  }
}