
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class IconElement
  {    
  }

  public class MissingIconElement:IconElement
  {

  }

  public enum TextureIconOverlayAlignment
  {
    None,
    Left,
    Center,
    Right
  }

  public class TextureIconElement:IconElement
  {
    public Texture2D texture;

    public float borderLeft;
    public float borderRight;
    public float borderTop;
    public float borderBottom;

    public float widthScale = 1;

    public float rotation = 0;

    public TextureIconOverlayAlignment alignment = TextureIconOverlayAlignment.None;

    public static TextureIconElement Create( Texture2D texture, float widthScale = 1, TextureIconOverlayAlignment alignment = TextureIconOverlayAlignment.None )
    {
      var tie = new TextureIconElement();
      tie.texture = texture;
      tie.widthScale = widthScale;
      tie.alignment = alignment;
      return tie;
    }

    public void SetBorders( DefaultInputIconDefinition definition )
    {
      borderLeft = definition.borderLeft;
      borderRight = definition.borderRight;
      borderTop = definition.borderTop;
      borderBottom = definition.borderBottom;
    }

    public bool hasBorders
    {
      get 
      {
        return ( borderLeft + borderRight + borderTop + borderBottom ) > 0;
      }
    }



  }
  

  public class LabelIconElement:IconElement
  {
    public LocalizedString locale;

    public float fontScale = 1;
    public bool fontIsUpperCase = true;

    public static LabelIconElement Create( LocalizedString locale, float fontScale = 1, bool upperCase = true )
    {
      var tie = new LabelIconElement();
      tie.locale = locale;
      tie.fontScale = fontScale;
      tie.fontIsUpperCase = upperCase;
      return tie;
    }
  }

}