
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class MouseInputIconDefinition: InputIconDefinition
  {  
    [Export]
    public Texture2D leftButtonTexture;

    [Export]
    public Texture2D middleButtonTexture;

    [Export]
    public Texture2D rightButtonTexture;

    [Export]
    public Texture2D wheelUpTexture;

    [Export]
    public Texture2D wheelDownTexture;

    [Export]
    public Texture2D wheelLeftTexture;

    [Export]
    public Texture2D wheelRightTexture;
  

    public override List<IconElement> GetIconElementsForIcon( InputIcon icon )
    { 
      var mouseIcon = icon as MouseInputIcon;

      if ( mouseIcon == null )
      {
        return null;
      }

      var list = new List<IconElement>();

      var button = mouseIcon.button;
      
      Texture2D texture = null;


      if ( MouseButton.Left == button )
      {
        texture = leftButtonTexture;
      }
      else if ( MouseButton.Middle == button )
      {
        texture = middleButtonTexture;
      }
      else if ( MouseButton.Right == button )
      {
        texture = rightButtonTexture;
      }
      else if ( MouseButton.WheelUp == button )
      {
        texture = wheelUpTexture;
      }
      else if ( MouseButton.WheelDown == button )
      {
        texture = wheelDownTexture;
      }
      else if ( MouseButton.WheelLeft == button )
      {
        texture = wheelLeftTexture;
      }
      else if ( MouseButton.WheelRight == button )
      {
        texture = wheelRightTexture;
      }

      if ( texture == null )
      {
        list.Add( new MissingIconElement() );
      }
      else
      {
        list.Add( TextureIconElement.Create( texture ) );
      }

      return list;
    }

    public override bool HasIconFor( InputIcon icon )
    {
      var mouseIcon = icon as MouseInputIcon;

      if ( mouseIcon == null )
      {
        return false;
      }

      var list = GetIconElementsForIcon( icon );
      return list != null && list.Count == 1 && ! ( list[ 0 ] is MissingIconElement );
    }
    

  }
}