    
using Godot;


namespace Rokojori
{ 
  public enum CombineIconOrderMode
  {
    Forward_Only,
    Forward_And_Reverse,
    Any_Order
  }

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class CombinedIcon:InputIcon
  {
    [Export]
    public InputIcon[] icons = new InputIcon[ 0 ];
    

    public override bool Equals( object obj )
    {
      var value = obj as CombinedIcon;

      if ( value == null )
      {
        return false;
      }

      return Arrays.AreEntriesEqual( icons, value.icons );
    }
  }
} 
  