    
using Godot;


namespace Rokojori
{ 
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class GamePadAxisIcon:InputIcon
  {
    [Export]
    public JoyAxis axis;

    [Export]
    public GamePadAxisType type;


    public override LocalizedString GetDefaultLocale()
    {
      return LocaleText.Create( "Axis " + axis + " " + type );
    }

    public override LocalizedString GetIconLocale()
    {
      return LocaleText.Create( GamePadIconSymbolsMap.GetSymbol( axis, type ) );
    }

    public override bool Equals( object obj )
    {
      var value = obj as GamePadAxisIcon;

      if ( value == null )
      {
        return false;
      }

      return value.axis == axis && value.type == type;
    }

    public override string ToString()
    {
      return "GamePadAxisIcon{ " + axis + " " + type + " }";
    }

  }
} 
  