    
using Godot;


namespace Rokojori
{ 
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class GamePadButtonIcon:InputIcon
  {
    [Export]
    public JoyButton button;

    public override LocalizedString GetDefaultLocale()
    {
      return LocaleText.Create( "Button " + button );
    }


    public override LocalizedString GetIconLocale()
    {
      return LocaleText.Create( GamePadIconSymbolsMap.GetSymbol( button ) );
    }

    public override bool Equals( object obj )
    {
      var value = obj as GamePadButtonIcon;

      if ( value == null )
      {
        return false;
      }

      return value.button == button;
    }

    public override string ToString()
    {
      return "GamePadButtonIcon{ " + button + " }";
    }
  }
} 
  