
using Godot;
using System.Collections.Generic;
using System;

namespace Rokojori
{ 
  public class GamePadIconSymbolsMap
  {
    public static string GetSymbol( JoyButton button )
    {
      if ( ! _buttonIconSymbols.ContainsKey( button ) )
      {
        return "<?>";
      }

      return _buttonIconSymbols[ button ];
    }

    static Dictionary<JoyButton,string> _buttonIconSymbols = new Dictionary<JoyButton, string>()
    {
      { JoyButton.A, "A" }, { JoyButton.B, "B" },{ JoyButton.X, "X" },{ JoyButton.Y, "Y" },
      { JoyButton.LeftStick, "LS" }, { JoyButton.RightStick, "RS" },
      { JoyButton.LeftShoulder, "LB" },{ JoyButton.RightShoulder, "RB" }
    };

    public static string GetSymbol( JoyAxis axis, GamePadAxisType axisType )
    {
      if ( ! _axisIconSymbols.ContainsKey( axis ) )
      {
        return "<?>";
      }

      var tuple = _axisIconSymbols[ axis ];

      return GamePadAxisType.Negative == axisType ? tuple.Item1 : tuple.Item2;
    }

    static Dictionary<JoyAxis,Tuple<string,string>> _axisIconSymbols = new Dictionary<JoyAxis, Tuple<string,string>>()
    {
      { JoyAxis.LeftX, Tuple.Create( "L🠜","L🠞" ) },
      { JoyAxis.RightX, Tuple.Create( "R🠜","R🠞") },
      { JoyAxis.LeftY, Tuple.Create( "L🠝","L🠟") }, 
      { JoyAxis.RightY,Tuple.Create( "R🠝","R🠟")},
      { JoyAxis.TriggerLeft, Tuple.Create( "LT","LT")}, 
      { JoyAxis.TriggerRight,Tuple.Create( "RT","RT")},
    };
  }
}