
using Godot;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class KeyIcon:InputIcon
  {
    [Export]
    public Key key;

    [Export]
    public KeyLocation location = KeyLocation.Unspecified;

    public override LocalizedString GetDefaultLocale()
    {
      return LocaleText.Create( "Key " + key );
    }

    public override LocalizedString GetIconLocale()
    {
      return LocaleText.Create( KeyIconSymbolsMap.GetSymbol( key ) );
    }

    public override bool Equals( object obj )
    {
      var value = obj as KeyIcon;

      if ( value == null )
      {
        return false;
      }

      return value.key == key && value.location == location;
    }

    public override string ToString()
    {
      return "KeyIcon{ " + key + "@" + location + " }";
    }
  }
} 
  