
using Godot;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class KeyIconSymbolsMap
  {
    public static string GetSymbol( Key key )
    {
      if ( ! _keyIconSymbols.ContainsKey( key ) )
      {
        return "<?>";
      }

      return _keyIconSymbols[ key ];
    }

    // Created from Key
    // Matcher: //     (.+)\skey.+\n\s+(\w+) = \d+
    // Replacement: { Key.$2, "$1" }

    static Dictionary<Key,string> _keyIconSymbols = new Dictionary<Key, string>()
    {

      { Key.Space, " " },
      { Key.Exclam, "!" },
      { Key.Quotedbl, "\"" },
      { Key.Numbersign, "#" },
      { Key.Dollar, "$" },
      { Key.Percent, "%" },
      { Key.Ampersand, "&" },
      { Key.Apostrophe, "'" },
      { Key.Parenleft, "(" },
      { Key.Parenright, ")" },
      { Key.Asterisk, "*" },
      { Key.Plus, "+" },
      { Key.Comma, "," },
      { Key.Minus, "-" },
      { Key.Period, "." },
      { Key.Slash, "/" },
      { Key.Key0, "0" },
      { Key.Key1, "1" },
      { Key.Key2, "2" },
      { Key.Key3, "3" },
      { Key.Key4, "4" },
      { Key.Key5, "5" },
      { Key.Key6, "6" },
      { Key.Key7, "7" },
      { Key.Key8, "8" },
      { Key.Key9, "9" },
      { Key.Colon, ":" },
      { Key.Semicolon, ";" },
      { Key.Less, "<" },
      { Key.Equal, "=" },
      { Key.Greater, ">" },
      { Key.Question, "?" },
      { Key.At, "@" },
      { Key.A, "A" },
      { Key.B, "B" },
      { Key.C, "C" },
      { Key.D, "D" },
      { Key.E, "E" },
      { Key.F, "F" },
      { Key.G, "G" },
      { Key.H, "H" },
      { Key.I, "I" },
      { Key.J, "J" },
      { Key.K, "K" },
      { Key.L, "L" },
      { Key.M, "M" },
      { Key.N, "N" },
      { Key.O, "O" },
      { Key.P, "P" },
      { Key.Q, "Q" },
      { Key.R, "R" },
      { Key.S, "S" },
      { Key.T, "T" },
      { Key.U, "U" },
      { Key.V, "V" },
      { Key.W, "W" },
      { Key.X, "X" },
      { Key.Y, "Y" },
      { Key.Z, "Z" },
      { Key.Bracketleft, "[" },
      { Key.Backslash, "\\" },
      { Key.Bracketright, "]" },
      { Key.Asciicircum, "^" },
      { Key.Underscore, "_" },
      { Key.Quoteleft, "`" },
      { Key.Braceleft, "{" },
      { Key.Bar, "|" },
      { Key.Braceright, "}" },
      { Key.Asciitilde, "~" },
      { Key.Yen, "¥" },
      { Key.Section, "§" },
      { Key.Escape, "Esc" },
      { Key.Tab, "⇥" },
      { Key.Backtab, "⇤" },
      { Key.Backspace, "←" },
      { Key.Enter, "Return" },
      { Key.KpEnter, "Enter" },
      { Key.Insert, "Ins" },
      { Key.Delete, "Del" },
      { Key.Pause, "Pause" },
      { Key.Print, "Prnt" },
      { Key.Sysreq, "Sys" },
      { Key.Clear, "Clr" },
      { Key.Home, "Home" },
      { Key.End, "End" },
      { Key.Left, "◂" },
      { Key.Up, "▴" },
      { Key.Right, "▸" },
      { Key.Down, "▾" },
      { Key.Pageup, "PUp" },
      { Key.Pagedown, "PDwn" },
      { Key.Shift, "⇧" },
      { Key.Ctrl, "Ctrl" },
      { Key.Meta, "Meta" },
      { Key.Alt, "Alt" },
      { Key.Capslock, "⇩" },
      { Key.Numlock, "Num Lock" },
      { Key.Scrolllock, "Scroll Lock" },
      { Key.F1, "F1" },
      { Key.F2, "F2" },
      { Key.F3, "F3" },
      { Key.F4, "F4" },
      { Key.F5, "F5" },
      { Key.F6, "F6" },
      { Key.F7, "F7" },
      { Key.F8, "F8" },
      { Key.F9, "F9" },
      { Key.F10, "F10" },
      { Key.F11, "F11" },
      { Key.F12, "F12" },
      { Key.F13, "F13" },
      { Key.F14, "F14" },
      { Key.F15, "F15" },
      { Key.F16, "F16" },
      { Key.F17, "F17" },
      { Key.F18, "F18" },
      { Key.F19, "F19" },
      { Key.F20, "F20" },
      { Key.F21, "F21" },
      { Key.F22, "F22" },
      { Key.F23, "F23" },
      { Key.F24, "F24" },
      { Key.F25, "F25" },
      { Key.F26, "F26" },
      { Key.F27, "F27" },
      { Key.F28, "F28" },
      { Key.F29, "F29" },
      { Key.F30, "F30" },
      { Key.F31, "F31" },
      { Key.F32, "F32" },
      { Key.F33, "F33" },
      { Key.F34, "F34" },
      { Key.F35, "F35" },
      { Key.Menu, "Context menu" },
      { Key.Hyper, "Hyper" },
      { Key.Help, "Help" },
      { Key.Back, "Media back" },
      { Key.Forward, "Media forward" },
      { Key.Stop, "Media stop" },
      { Key.Refresh, "Media refresh" },
      { Key.Volumedown, "+" },
      { Key.Volumemute, "🔇" },
      { Key.Volumeup, "-" },
      { Key.Mediaplay, "Media play" },
      { Key.Mediastop, "Media stop" },
      { Key.Mediaprevious, "Previous song" },
      { Key.Medianext, "Next song" },
      { Key.Mediarecord, "Media record" },
      { Key.Homepage, "Home page" },
      { Key.Favorites, "Favorites" },
      { Key.Search, "Search" },
      { Key.Standby, "Standby" },
      { Key.Openurl, "Open URL / Launch Browser" },
      { Key.Launchmail, "Launch Mail" },
      { Key.Launchmedia, "Launch Media" },
      { Key.Launch0, "Launch Shortcut 0" },
      { Key.Launch1, "Launch Shortcut 1" },
      { Key.Launch2, "Launch Shortcut 2" },
      { Key.Launch3, "Launch Shortcut 3" },
      { Key.Launch4, "Launch Shortcut 4" },
      { Key.Launch5, "Launch Shortcut 5" },
      { Key.Launch6, "Launch Shortcut 6" },
      { Key.Launch7, "Launch Shortcut 7" },
      { Key.Launch8, "Launch Shortcut 8" },
      { Key.Launch9, "Launch Shortcut 9" },
      { Key.Launcha, "Launch Shortcut A" },
      { Key.Launchb, "Launch Shortcut B" },
      { Key.Launchc, "Launch Shortcut C" },
      { Key.Launchd, "Launch Shortcut D" },
      { Key.Launche, "Launch Shortcut E" },
      { Key.Launchf, "Launch Shortcut F" },
      { Key.Globe, "Globe" },
      { Key.Keyboard, "On-screen keyboard" },
      { Key.JisEisu, "英数" },
      { Key.JisKana, "かな" },
      { Key.KpMultiply, "*" },
      { Key.KpDivide, "/" },
      { Key.KpSubtract, "-" },
      { Key.KpPeriod, "." },
      { Key.KpAdd, "+" },
      { Key.Kp0, "0" },
      { Key.Kp1, "1" },
      { Key.Kp2, "2" },
      { Key.Kp3, "3" },
      { Key.Kp4, "4" },
      { Key.Kp5, "5" },
      { Key.Kp6, "6" },
      { Key.Kp7, "7" },
      { Key.Kp8, "8" },
      { Key.Kp9, "9" }
    };
  }
}