
using Godot;


namespace Rokojori
{ 
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class MouseInputIcon:InputIcon
  {
    [Export]
    public MouseButton button;

    public override LocalizedString GetDefaultLocale()
    {
      return LocaleText.Create( "Mouse " + button );
    }

    public override LocalizedString GetIconLocale()
    {
      if ( MouseButton.Left == button )
      {
        return LocaleText.Create( "LMB" );
      }
      else if ( MouseButton.Middle == button )
      {
        return LocaleText.Create( "MMB" );
      }
      else if ( MouseButton.Right == button )
      {
        return LocaleText.Create( "RMB" );
      }
      else if ( MouseButton.WheelUp == button )
      {
        return LocaleText.Create( "MWU" );
      }
      else if ( MouseButton.WheelDown == button )
      {
        return LocaleText.Create( "MWD" );
      }
      else if ( MouseButton.WheelLeft == button )
      {
        return LocaleText.Create( "MWL" );
      }
      else if ( MouseButton.WheelRight == button )
      {
        return LocaleText.Create( "MWR" );
      }

      return GetDefaultLocale();
    }

    public override bool Equals( object obj )
    {
      var value = obj as MouseInputIcon;

      if ( value == null )
      {
        return false;
      }

      return value.button == button;
    }

     public override string ToString()
    {
      return "MouseInputIcon{ " + button + " }";
    }
  }
} 
  