
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class InputMapActionSensor: Sensor
  {
    [Export]
    public string inputActionName = "";

    public enum PollMode
    {
      Button,
      Half_Axis,
      Release_Only_Button
    }

    [Export]
    public PollMode pollMode = PollMode.Button;
    
    public override string ToString()
    {
      return RJLog.GetInfo( this, inputActionName, pollMode );
    }

    protected override void UpdateValue()
    {
      if ( PollMode.Button == pollMode )
      {
        SetBoolValue( Input.IsActionPressed( inputActionName ) );
      }
      else if ( PollMode.Release_Only_Button == pollMode )
      {
        SetBoolValue( Input.IsActionJustReleased( inputActionName ) );
      }
      else if ( PollMode.Half_Axis == pollMode )
      {
        SetFloatValue( Input.GetActionRawStrength( inputActionName ) );
      }    
    }

    [Export]
    public InputIcon[] inputIcons = new InputIcon[ 0 ];

    public override List<InputIcon> GetInputIcons()
    {
      return Lists.From( inputIcons );
    }
    
  }
}