
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/MouseSensor.svg")]
  public partial class MouseMotionDelta : Sensor, iOnInputSensor
  {
    public enum MouseMotionType
    {
      Right,
      Left,
      Up,
      Down
    }

    [Export]
    public MouseMotionType motionType;

    [Export]
    public float speedMultiply = 1;

    public override string ToString()
    {
      return RJLog.GetInfo( this, motionType, speedMultiply );
    }

    float _lastInput = 0;

    protected override void UpdateValue()
    {
      SetFloatValue( _lastInput );
      _lastInput = 0;
    }

    public void _Input( InputEvent ev )
    {
      var mouseEvent = ev as InputEventMouseMotion ;

      if ( mouseEvent == null )
      {
        return;
      } 

      var delta = mouseEvent.ScreenRelative;
      var motion = 0f;

      if ( MouseMotionType.Left == motionType)
      {
        motion = Mathf.Max( 0, -delta.X );
      }
      else if ( MouseMotionType.Right == motionType)
      {
        motion = Mathf.Max( 0, delta.X );
      }
      else if ( MouseMotionType.Up == motionType)
      {
        motion = Mathf.Max( 0, delta.Y );
      }
      if ( MouseMotionType.Down == motionType)
      {
        motion = Mathf.Max( 0, -delta.Y );
      } 

      // RJLog.Log( "Motion:", motionType, motion * speedMultiply );

      _lastInput = motion * speedMultiply;

      UpdateSensorUsage();
  
    }
        
  }
}