
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/MouseSensor.svg")]
  public partial class MouseScreenRelative : Sensor, iOnInputSensor
  {
    public enum MouseMotionType
    {
      Right,
      Left,
      Up,
      Down
    }

    [Export]
    public MouseMotionType motionType;

    float _lastInput = 0;

    protected override void UpdateValue()
    {
      SetFloatValue( _lastInput );
    }

    public override string ToString()
    {
      return RJLog.GetInfo( this, motionType );
    }

    public void _Input( InputEvent ev )
    {
      var mouseEvent = ev as InputEventMouseMotion ;

      if ( mouseEvent == null )
      {
        return;
      } 

      var vp = Unique<SensorManager>.Get().GetViewport();
      var relativePosition = mouseEvent.Position / vp.GetVisibleRect().Size * 2 - Vector2.One;
      var position = 0f;

      // RJLog.Log( mouseEvent.Position );

      if ( MouseMotionType.Left == motionType)
      {
        position = Mathf.Max( 0, -relativePosition.X );
      }
      else if ( MouseMotionType.Right == motionType)
      {
        position = Mathf.Max( 0, relativePosition.X );
      }
      else if ( MouseMotionType.Up == motionType)
      {
        position = Mathf.Max( 0, relativePosition.Y );
      }
      if ( MouseMotionType.Down == motionType)
      {
        position = Mathf.Max( 0, -relativePosition.Y );
      } 

      // RJLog.Log( "Motion:", motionType, motion * speedMultiply );

      _lastInput = position;
  
    }

        
  }
}