
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Sensor.svg")]
  public partial class Sensor: Resource
  {  
    [Export]
    public LocaleText name;

    [Export]
    public LocaleText info;

    [Export]
    public bool continous = false;

    protected float _value = 0;

    protected bool _wasActive = false;

    protected bool _active = false;

    protected float _activeTreshold = 0.5f;

    protected bool _consumed = false;

    public void ProcessSensor( SensorRunner runner, float delta )
    {
      _wasActive = _active;
      UpdateValue();
    }

    public bool isDown => ! _wasActive && _active;
    public bool isUp   => _wasActive && ! _active;
    public bool isHold => _active;

    public bool wasActive => _wasActive;
    public bool isActive => _active;

    public float value => _value;

    public virtual int deviceID => 0;
    public virtual bool isMultiDevice => false;

    public virtual float GetValue( int device ) => value;
    public virtual bool IsDown( int device ) => isDown;
    public virtual bool IsUp( int device ) => isUp;

    public virtual bool WasActive( int device ) => isUp;
    public virtual bool IsActive( int device ) => isUp;


    public bool consumed => _consumed;
    
    public void Consume()
    {
      _consumed = true;
    }

    protected virtual void UpdateValue()
    {

    }

    protected void SetBoolValue( bool activeState )
    {
      _active = activeState;
      _value = activeState ? 1 : 0;
      _consumed = false;
    }

    protected void SetFloatValue( float value )
    {
      _value = value;
      _active = value > _activeTreshold;
      _consumed = false;
    }

    public virtual List<InputIcon> GetInputIcons()
    {
      return new List<InputIcon>();
    }

    protected void UpdateSensorUsage( int index = 0 )
    {
      var sm = Unique<SensorManager>.Get();

      if ( sm == null )
      {
        return;
      }
      
      sm.UpdateLastActiveDevice( this, index );
    }
    
  }
}