
using Godot;


namespace Rokojori
{  
  public class SensorEvent
  {
    protected Sensor _sensor;
    public Sensor sensor => _sensor;

    protected bool _cancelled = false;
    public bool cancelled => _cancelled;

    public void Cancel()
    {
      _cancelled = true;
    }

    public bool isDown => _sensor.isDown;
    public bool isUp   => _sensor.isUp;

    public bool wasActive => _sensor.wasActive;
    public bool isActive  => _sensor.isActive;
    public bool isHold    => _sensor.isHold;

    public virtual float GetValue( int device ) => _sensor.GetValue( device );
    public virtual bool IsDown( int device ) => _sensor.IsDown( device );
    public virtual bool IsUp( int device ) => _sensor.IsUp( device );

    public virtual bool WasActive( int device ) => _sensor.WasActive( device );
    public virtual bool IsActive( int device ) => _sensor.IsActive( device );

    public float value => _sensor.value;

    public bool IsSensor( Sensor s )
    {
      return _sensor == s;
    }

    public bool IsDown( Sensor s )
    {
      return IsSensor( s ) && isDown;
    }

    public bool IsUp( Sensor s )
    {
      return IsSensor( s ) && isUp;
    }

    public bool IsHold( Sensor s )
    {
      return IsSensor( s ) && isHold;
    }
  }

  public class EditableSensorEvent:SensorEvent
  {
    public EditableSensorEvent( Sensor sensor )
    {
      this._sensor = sensor;
    }

    public void Reset()
    {
      _cancelled = false;
    }
  }


}