
using Godot;
using System.Collections.Generic;
using System;
namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorManager.svg")]
  public partial class SensorManagerSetup: Node
  {
    [Export]
    public bool initializeOnReady = true;

    [Export]
    public bool processSensors = true;

    [ExportGroup( "Sensor Scanning" )]
    [Export]
    public Sensor[] sensors = [];

    [Export]
    public SensorGroup[] sensorGroups = [];

    [Export]
    public bool autoScan = true;

    [Export]
    public Node[] autoScanForSensors = [];

    [Export]
    public bool autoScanParent = true;

    [ExportGroup( "Device Options" )]
    [Export]
    public SensorDevice initialDevice;

    [ExportGroup( "Debugging Options")]

    [Export]
    public bool separateMouseAndKeyboardTracking = false; 

    [Export]
    public Action onActiveDeviceChange;

    [Export]
    public bool showRegistratedSensors = true;

    [Export]
    public bool confineMouse = false;

    public override void _Ready()
    {
      if ( Engine.IsEditorHint() )
      {
        return;
      }

      var sm = this.CreateChild<SensorManager>( "SensorManager" );
      
      sm.sensors = sensors;
      sm.sensorGroups = sensorGroups;
      sm.processSensors = processSensors;
      sm.autoScan = autoScan;
      sm.autoScanForSensors = autoScanForSensors;
      sm.separateMouseAndKeyboardTracking = separateMouseAndKeyboardTracking;
      sm.onActiveDeviceChange = onActiveDeviceChange;
      sm.showRegistratedSensors = showRegistratedSensors;
      sm.confineMouse = confineMouse;
      sm.initialDevice = initialDevice;
      

      if ( autoScanParent )
      {
        sm.autoScanForSensors = Arrays.Add( sm.autoScanForSensors, GetParent() );
      }

      if ( initializeOnReady )
      {
        sm.Initialize();
      }
    }

  }
}