
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class SensorRunner
  {
    public Sensor sensor;
    public List<SensorInputHandler> listeners = new List<SensorInputHandler>();
    float _lastValue = 0; 

    EditableSensorEvent sensorEvent;

    public SensorRunner( Sensor sensor )
    {
      this.sensor = sensor;

      sensorEvent = new EditableSensorEvent( sensor );
    }

    public void Update( float delta )
    {      
      sensor.ProcessSensor( this, delta );

      if ( ! sensor.continous && sensor.value == _lastValue )
      {
        return;
      }

      sensorEvent.Reset();

      listeners.ForEach( l => l._OnSensor( sensorEvent ) );

      _lastValue = sensor.value;
    }
  }
}