
using Godot;


namespace Rokojori
{ 
  public class Sensors
  {
    public static bool IsDown( Sensor sensor, int device = 0 )
    {
      return sensor == null ? false : sensor.IsDown( device );
    }

    public static bool IsActive( Sensor sensor )
    {
      return sensor == null ? false : sensor.isActive;
    }

    public static float GetValue( Sensor sensor, float scale = 1, float deadZone = 0.3f )
    {
      if ( sensor == null )
      {
        return 0;
      }

      var rawValue = sensor.value;

      var clamped = MathX.NormalizeClamped( rawValue, deadZone, 1 );

      return clamped * scale;
    } 

    public static float PolarAxis( Sensor negative, Sensor positive, float scale = 1, float deadZone = 0.3f )
    {
      return - GetValue( negative, scale, deadZone ) + GetValue( positive, scale, deadZone );
    }

    public static float PolarPowerAxis( Sensor negative, Sensor positive, float scale = 1, float deadZone = 0.3f, float power = 1.0f )
    {
      return - Mathf.Pow( GetValue( negative, scale, deadZone ), power ) + Mathf.Pow( GetValue( positive, scale, deadZone ), power );
    }

    public static Vector2 FourDirectional( Sensor left, Sensor right, Sensor up, Sensor down, bool normalize = true, float deadZone = 0.3f )
    {
      var x = PolarAxis( left, right, 1, deadZone );
      var y = PolarAxis( up, down, 1, deadZone );
      

      var v = new Vector2( x, y );

      if ( normalize && v.Length() > 1 )
      {
        v = v.Normalized();
      } 

      return v;


    }
  }
}