
using Godot;


namespace Rokojori
{  
  [Tool][GlobalClass, Icon("res://addons/rokojori_action_library/Icons/OnEvent.svg") ]
  public partial class TriggerOnSensor: Node, SensorInputHandler
  {
    [Export]
    public Sensor sensor;

    [Export]
    public Action action;

    public override void _Ready()
    {  
      this.LogInfo( "Root" );
      SensorManager.Register( this, sensor );
    }

    public override void _ExitTree()
    {
      SensorManager.Unregister( this, sensor );
    }

    public void _OnSensor( SensorEvent se )
    { 
      RJLog.Log( se, se.IsDown( sensor ) );
      
      if ( se.IsDown( sensor ) )
      {
        Action.Trigger( action );
      }
    }


  }
}