using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{ 
  
  public class ShaderCodeVariable
  {
    public static readonly ShaderCodeVariable VERTEX = new ShaderCodeVariable( "VERTEX", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable NORMAL = new ShaderCodeVariable( "NORMAL", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable UV = new ShaderCodeVariable( "UV", ShaderCodeStages.Spatial, true );

    public static readonly ShaderCodeVariable ALBEDO = new ShaderCodeVariable( "ALBEDO", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable ALPHA = new ShaderCodeVariable( "ALPHA", ShaderCodeStages.Spatial, true );

    public static readonly ShaderCodeVariable NORMAL_MAP = new ShaderCodeVariable( "NORMAL_MAP", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable NORMAL_MAP_DEPTH = new ShaderCodeVariable( "NORMAL_MAP_DEPTH", ShaderCodeStages.Spatial, true );
    
    public static readonly ShaderCodeVariable AO = new ShaderCodeVariable( "AO", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable ROUGHNESS = new ShaderCodeVariable( "ROUGHNESS", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable METALLIC = new ShaderCodeVariable( "METALLIC", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable SPECULAR = new ShaderCodeVariable( "SPECULAR", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable EMISSION = new ShaderCodeVariable( "EMISSION", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable BACKLIGHT = new ShaderCodeVariable( "BACKLIGHT", ShaderCodeStages.Spatial, true );

    public static readonly ShaderCodeVariable SSS_STRENGTH = new ShaderCodeVariable( "SSS_STRENGTH", ShaderCodeStages.Spatial, true );

    public static readonly ShaderCodeVariable SSS_TRANSMITTANCE_COLOR = new ShaderCodeVariable( "SSS_TRANSMITTANCE_COLOR", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable SSS_TRANSMITTANCE_DEPTH = new ShaderCodeVariable( "SSS_TRANSMITTANCE_DEPTH", ShaderCodeStages.Spatial, true );
    public static readonly ShaderCodeVariable SSS_TRANSMITTANCE_BOOST = new ShaderCodeVariable( "SSS_TRANSMITTANCE_BOOST", ShaderCodeStages.Spatial, true );

    public static readonly ShaderCodeVariable MODEL_MATRIX = new ShaderCodeVariable( "MODEL_MATRIX", ShaderCodeStages.Spatial, true );
    
    public static readonly List<ShaderCodeVariable> DefaultVariables = 
    [
      VERTEX, NORMAL, UV, 
      ALBEDO, ALPHA,
      NORMAL_MAP, NORMAL_MAP_DEPTH,
      AO, ROUGHNESS, METALLIC, SPECULAR,
      EMISSION, BACKLIGHT, SSS_STRENGTH,
      SSS_TRANSMITTANCE_COLOR, SSS_TRANSMITTANCE_DEPTH, SSS_TRANSMITTANCE_BOOST,
      MODEL_MATRIX
    ];

    string _variableName;
    public string variableName => _variableName;

    bool _builtIn = false;
    public bool builtIn => _builtIn;

    List<ShaderCodeStage> _stages = new List<ShaderCodeStage>();
    public List<ShaderCodeStage> stages => _stages;


    public ShaderCodeVariable( string name, List<ShaderCodeStage> stages, bool builtIn = false )
    {
      _variableName = name;
      _stages = stages;
      _builtIn = builtIn;
      
    }  
  }


}