using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{   
  public enum ShaderCodeVariableOccuranceType
  {
    Read,
    Assignment, // =
    Modification // ++, --, +=, *=
  }

  public class ShaderCodeVariableOccurance
  { 
    public ShaderCodeVariableOccuranceType type;
    public ShaderCodeVariable variable;


    public static ShaderCodeVariableOccurance AsType( string name, ShaderCodeVariableOccuranceType type )
    {
      var variable = new ShaderCodeVariable( name, ShaderCodeStages.Spatial );
      var occurance = new ShaderCodeVariableOccurance();
      occurance.variable = variable;
      occurance.type = type;
      return occurance; 
    }

    public static ShaderCodeVariableOccurance Read( string name )
    {
      return AsType( name, ShaderCodeVariableOccuranceType.Read );
    } 
    
    public static ShaderCodeVariableOccurance Assignment( string name )
    {
      return AsType( name, ShaderCodeVariableOccuranceType.Assignment );
    }

     public static ShaderCodeVariableOccurance Modification( string name )
    {
      return AsType( name, ShaderCodeVariableOccuranceType.Modification );
    }


  }
}