using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class ShaderGenerationContext
  {
    public ShaderPhase phase;
    
    public List<ShaderVariant> variants = new List<ShaderVariant>();   

    public bool IsPhase( ShaderPhase phase )
    {
      return phase == this.phase;
    }

    public bool isIncludesPhase => IsPhase( ShaderPhase.Includes );
    public bool isVariablesPhase => IsPhase( ShaderPhase.Variables );
    public bool isVertexPhase => IsPhase( ShaderPhase.Vertex );
    public bool isFragmentPhase => IsPhase( ShaderPhase.Fragment );

    public ShaderGenerationContext()
    {
      variants.Add( new ShaderVariant() );
    }
    
    public void AddVariants( List<ShaderVariant> code )
    {
      if ( code == null || code.Count == 0 )
      {
        return;
      }
      
      var newVariants = new List<ShaderVariant>();

      for ( int i = 0; i < variants.Count; i++ )
      {
        var v = variants[ i ];

        for ( int j = 0; j < code.Count; j++ )
        {
          newVariants.Add( v.Extend( code[ j ] ) );
        }
      }

      variants = newVariants;
    }
  }
}