using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.IO;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class ShaderRawModule:ShaderGenerationModule
  { 
  
    [Export]
    public string value;

    [Export]
    public ShaderPhase phase;

    [Export]
    public bool matchPhase = false;

    public ShaderRawModule( string value, ShaderPhase? phase = null )
    {
      sortableCode = false;
      
      if ( phase != null )
      {
        phase = (ShaderPhase) phase;
        matchPhase = true;
      }
      else
      {
        matchPhase = false;
      }

      this.value = value;
    }
    
    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      if ( matchPhase && context.phase != phase )
      {
        return null;
      }

      return ToVariants( ToCode( value ) );      
    }
  }
}