using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  public enum ShaderShapeType
  {
    Point,
    Sphere,
    Box,
    RoundBox,
    Line,
    Capsule,
    RoundCone,
    Triangle,
    Quad
  }

  public class ShaderShape3DDefinition
  {
    public ShaderShapeType shaderShapeType;
    public List<ShaderProperty> shaderProperties = [];

    public ShaderShape3DDefinition( ShaderShapeType type, List<ShaderProperty> properties )
    {
      this.shaderShapeType = type;
      this.shaderProperties = properties;
    }
    
  }


  public partial class ShaderShapes3D:ShaderGenerationModule
  { 
    public static ShaderShape3DDefinition Point = new ShaderShape3DDefinition(
      ShaderShapeType.Point, 
      [
        Vector3Property.Create( "point", Vector3.Zero )
      ]
    );

    public static ShaderShape3DDefinition Sphere = new ShaderShape3DDefinition(
      ShaderShapeType.Sphere, 
      [
        Vector3Property.Create( "sphereCenter", Vector3.Zero ),
        FloatProperty.Create( "sphereRadius", 1f )
      ]
    );

    public static ShaderShape3DDefinition Box = new ShaderShape3DDefinition(
      ShaderShapeType.Box, 
      [
        Vector3Property.Create( "boxDimensions", Vector3.One )
      ]
    );

    public static ShaderShape3DDefinition RoundBox = new ShaderShape3DDefinition(
      ShaderShapeType.RoundBox, 
      [
        Vector3Property.Create( "boxDimensions", Vector3.One ),
        FloatProperty.Create( "boxRadius", 0.1f )
      ]
    );

    public static ShaderShape3DDefinition Line = new ShaderShape3DDefinition(
      ShaderShapeType.Line, 
      [
        Vector3Property.Create( "lineStart", Vector3.Zero ),
        Vector3Property.Create( "lineEnd", Vector3.One ),
      ]
    );

    public static ShaderShape3DDefinition Capsule = new ShaderShape3DDefinition(
      ShaderShapeType.Capsule, 
      [
        Vector3Property.Create( "capsuleStart", Vector3.Zero ),
        Vector3Property.Create( "capsuleEnd", Vector3.One ),
        FloatProperty.Create( "capsuleRadius", 0.1f )
      ]
    );

    public static ShaderShape3DDefinition RoundCone = new ShaderShape3DDefinition(
      ShaderShapeType.RoundCone, 
      [
        Vector3Property.Create( "roundConeStart", Vector3.Zero ),
        Vector3Property.Create( "roundConeEnd", Vector3.One ),
        FloatProperty.Create( "roundConeStartRadius", 0.1f ),
        FloatProperty.Create( "roundConeEndRadius", 0.2f )
      ]
    );

    public static ShaderShape3DDefinition Triangle = new ShaderShape3DDefinition(
      ShaderShapeType.Triangle, 
      [
        Vector3Property.Create( "triangleA", new Vector3( 0, 0, 0 ) ),
        Vector3Property.Create( "triangleB", new Vector3( 1, 0, 0 )  ),
        Vector3Property.Create( "triangleC", new Vector3( 1, 1, 0 )  )
      ]
    );

    public static ShaderShape3DDefinition Quad = new ShaderShape3DDefinition(
      ShaderShapeType.Quad, 
      [
        Vector3Property.Create( "quadA", new Vector3( 0, 0, 0 ) ),
        Vector3Property.Create( "quadB", new Vector3( 1, 0, 0 )  ),
        Vector3Property.Create( "quadC", new Vector3( 1, 1, 0 )  ),
        Vector3Property.Create( "quadD", new Vector3( 0, 1, 0 )  )
      ]
    );


    public List<ShaderCode> GetCode( ShaderGenerationContext context )
    {
      if ( context.isIncludesPhase )
      {
        return IncludeSDFLibrary();
      }

      if ( context.isVariablesPhase )
      {
        return IncludeSDFLibrary();
      }

      return IncludeSDFLibrary();
    }
  } 
}