using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class AlbedoOverlayLayer:SpatialOverlayLayer
  { 
    [Export]
    public AlbedoModule layer = new AlbedoModule();

    public AlbedoOverlayLayer()
    {
      channelType = ChannelType.RGB;
    }

    public override List<ShaderCode> GetLayerCode( ShaderGenerationContext context, string name, string currentValueName )
    {      
      layer.SetDomainNames( name );
      layer._target = currentValueName;

      layer.uniformGroup = "";

      var variants = layer.GetVariants( context );

      if ( variants == null || variants.Count == 0 )
      {
        return null;
      }
      
      return variants[ 0 ].shaderCode;

    }
  }
}