using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{
  public enum AlphaFadeMode
  {
    ___,
    Alpha,  
    NoiseDitherDiscard,
    DiscardTresholdZero,
    DiscardTresholdHalf,
    DiscardTresholdOne
  }


  public static class AlphaFade
  {
    public static List<ShaderCode> Includes( string variableName, AlphaFadeMode mode )
    {
      if ( AlphaFadeMode.NoiseDitherDiscard != mode )
      {
        return null;
      }

      return ShaderGenerationModule.IncludeNoiseLibrary();
    } 

    
  
    public static string Fragment( string variableName, AlphaFadeMode mode )
    {
      if ( AlphaFadeMode.Alpha == mode )
      {
        return "  ALPHA *= " + variableName + ";\n";
      }

      if ( AlphaFadeMode.DiscardTresholdZero == mode )
      {
        var code = 
        $@"
        if ( {variableName} <= 0.001 )
        {{
          discard;
        }}
        ";

        return code.Indent( "  ");
      }

      if ( AlphaFadeMode.DiscardTresholdOne == mode )
      {
        var code = 
        $@"
        if ( {variableName} < 1.0 )
        {{
          discard;
        }}
        ";

        return code.Indent( "  ");
      }

      if ( AlphaFadeMode.DiscardTresholdHalf == mode )
      {
        var code = 
        $@"
        if ( {variableName} <= 0.5 )
        {{
          discard;
        }}
        ";

        return code.Indent( "  ");
      }

      if ( AlphaFadeMode.NoiseDitherDiscard == mode )
      {

        var code = 
        $@"
        if ( ditherDiscard( {variableName}, FRAGCOORD ) )
        {{
          discard;
        }}
        ";

        return code.Indent( "  ");
      }

      return null;
    }

  }
} 

