using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class AlphaModule:TextureModule
  { 
    public AlphaModule()
    {
      _domainName = "alpha";
      _domainScaleName = "alpha";
      _domainOffsetName = "alphaOffset";
      _domainValueName = "alpha";
      
      _target = "ALPHA";
      _type = TextureChannelType.ONE;
      _channelSource = TextureChannelSource.R;
      domainScaleDefault = 1f;
    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public DomainMode domainMode = DomainMode.Texture_Scale;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;

    [Export]
    public AssignmentType assignmentType = AssignmentType.Set;   
    
    public override void GrabValues()
    {
      _domainMode = domainMode;
      _textureFilter = filter;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;
      
      _assignmentType = assignmentType;
    }
  }
}