using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class BacklightModule:TextureModule
  { 
    public BacklightModule()
    {
      _domainName = "backlight";
      _domainScaleName = "backlight";
      _domainValueName = "backlight";
      
      _target = "BACKLIGHT";
      _srgb = true;
      _type = TextureChannelType.RGB;
      scaleType = TextureChannelType.RGB;
      scaleColor = Colors.Black;
    }

    [Export]
    public TextureFilter filter = TextureFilter.Linear_MipMap_Anisotropic;

    [Export]
    public bool useTint = true;

    [Export]
    public bool feedAlbedoIntoBacklight = true;

    [Export]
    public bool srgb = true;

    [Export]
    public bool repeat = true;

    [Export]
    public string uvChannel = "UV";

    [Export]
    public TextureDefault textureDefault = TextureDefault.White;

    [Export]
    public AssignmentType assignmentType = AssignmentType.Set;   
    
    public override void GrabValues()
    {
      _domainMode = useTint ? DomainMode.Texture_Scale : DomainMode.Texture;
      _textureFilter = filter;
      _srgb = srgb;
      _repeat = repeat;
      _textureDefault = textureDefault;
      _uvChannel = uvChannel;
      
      _assignmentType = assignmentType;
    }

    public override string AddVariables()
    {
      if ( ! feedAlbedoIntoBacklight )
      {
        return "";
      }

      return "\n" + Uniform01( "backlightFromAlbedo", 0.0f );
    }

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {
      var variants = base.GetVariants( context );

      if ( ! feedAlbedoIntoBacklight || ShaderPhase.Fragment != context.phase )
      {
        return variants;
      }

      var backlightAssignment = "  BACKLIGHT += backlightFromAlbedo * ALBEDO;\n\n";
      return ShaderVariant.CombineVariants( variants, ToVariants( ToCode( backlightAssignment ) ) );
      
    }
  }
}