using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class DepthPromixityFading:FadingModifier
  {     
    public override List<ShaderCode> GetFadingCode( ShaderGenerationContext context, int offsetIndex, AlphaFadeMode parentFadeMode )
    {
      var alphaFadeMode = GetFadeMode( parentFadeMode );
      var suffix = GetSuffix( offsetIndex );

      if ( context.isIncludesPhase )
      {
        return IncludeDepthLibrary();
      }

      if ( context.isVariablesPhase )
      {
        var depthProximityFadeDistanceUniform = Uniform( "depthProximityFadeDistance" + suffix, 0.2f, 0, 1000 ).LineBreak();
        
        var list = new List<ShaderCode>()
        {
          BuiltInTextureShaderCode.Depth,
          ToCode( depthProximityFadeDistanceUniform )
        };

        return list;
      }


      if ( context.isFragmentPhase )
      {
        var code = 
        $@"

        float depthProximityAlpha{suffix} = getDepthProximityAlpha( depthTexture, 
                                      SCREEN_UV, INV_PROJECTION_MATRIX, 
                                      VERTEX.z, depthProximityFadeDistance{suffix} 
                                    );
        ";


        return ToCode( code.Indent( "  " ) ).Concat(  ToCode( AlphaFade.Fragment( "depthProximityAlpha" + suffix, alphaFadeMode ) ) );
      }

      return [];
    }    

  }
}