using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public abstract partial class FadingModifier:ShaderGenerationModule
  { 
    [Export]
    public AlphaFadeMode alphaFadeMode = AlphaFadeMode.___;

    [Export]
    public bool createUniformGroup = false;


    public abstract List<ShaderCode> GetFadingCode( ShaderGenerationContext context, int offsetIndex, AlphaFadeMode parentAlphaFadeMode );

    public virtual bool IsSameType( FadingModifier modifier )
    {
      return modifier.GetType() == GetType();
    }

    public override List<ShaderVariant> GetVariants( ShaderGenerationContext context )
    {    
      return ToVariants( GetFadingCode( context, -1, alphaFadeMode ) );
    }

    public string GetSuffix( int offsetIndex )
    {
      return offsetIndex <= 0 ? "" : ( "_" + ( offsetIndex + 1 ) ); 
    }

    public AlphaFadeMode GetFadeMode( AlphaFadeMode parent )
    {
      if ( AlphaFadeMode.___ != alphaFadeMode )
      {
        return alphaFadeMode;
      }

      if ( AlphaFadeMode.___ != parent )
      {
        return parent;
      }

      return AlphaFadeMode.Alpha;
    }
  }
}