using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public partial class GeometryBillboardBending:GeometryModifier
  {   
    public override List<ShaderCode> GetGeometryCode( ShaderGenerationContext context, int offsetIndex )
    {
      if ( offsetIndex != 0 )
      {
        throw new System.Exception( "Unique component, can't be used multiple times");
      }

      if ( ShaderPhase.Includes == context.phase )
      { 
        return IncludeBillboardLibrary();
      }

      if ( ShaderPhase.Variables == context.phase )
      {        
        return AsUniformGroup( "BillboardBending",
          
        @"
        uniform float billboardBendingAmount;
        uniform float billboardBendingMaxAmount;
        uniform float billboardBendingEdgeScale:hint_range(0,2) = 0.5;
        uniform float billboardBendingMinY = 0.0;
        uniform float billboardBendingMaxY = 0.25;
        "
          
        );
           
      }

      if ( ShaderPhase.Vertex == context.phase )
      {

        return ToInnerBlock( "BillboadBending",
          
        @" 
        applyBillboardBendingWithDirection( 
          VERTEX, 
          CAMERA_DIRECTION_WORLD, 
          CAMERA_POSITION_WORLD,
          MODEL_MATRIX,
          VIEW_MATRIX,
          PROJECTION_MATRIX,
          INV_VIEW_MATRIX,
          billboardBendingAmount,
          billboardBendingMaxAmount,
          billboardBendingEdgeScale,
          billboardBendingMinY,
          billboardBendingMaxY,
          vec3( rj_GlobalWindDirection.x, 0.0, rj_GlobalWindDirection.y )
        );
        
        "
                  
        );
      }

      return null;
    }

  }
}