using Godot;
using System.Reflection;
using System.Collections.Generic;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass]
  public abstract partial class GeometryModifier:ShaderGenerationModule
  { 
    public virtual bool IsSameType( GeometryModifier modifier )
    {
      return modifier.GetType() == GetType();
    }

    public abstract List<ShaderCode> GetGeometryCode( ShaderGenerationContext context, int offsetIndex );
    

    public string GetSuffix( int offsetIndex )
    {
      return offsetIndex <= 0 ? "" : ( "_" + ( offsetIndex + 1 ) ); 
    }
  }
}